/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.AncientBlazeConfig;
import com.tristankechlo.livingthings.entity.ai.AncientBlazeChargeUpGoal;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class AncientBlazeEntity
extends Monster
implements PowerableMob,
RangedAttackMob,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> SHOOTS = SynchedEntityData.m_135353_(AncientBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> INVULNERABLE_TIME = SynchedEntityData.m_135353_(AncientBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);

    public AncientBlazeEntity(EntityType<? extends AncientBlazeEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 30;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, AncientBlazeConfig.health()).m_22268_(Attributes.f_22279_, AncientBlazeConfig.movementSpeed()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, AncientBlazeConfig.attackDamage());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.setInvulnerableTime(AncientBlazeConfig.chargingTime());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AncientBlazeChargeUpGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 20.0f));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INVULNERABLE_TIME, (Object)0);
        this.f_19804_.m_135372_(SHOOTS, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ChargedTime", this.getInvulnerableTime());
        compound.m_128344_("Shoots", this.getShoots());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setInvulnerableTime(compound.m_128451_("ChargedTime"));
        this.setShoots(compound.m_128445_("Shoots"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_9236_().m_5776_() && this.getInvulnerableTime() == 0) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.ANCIENT_BLAZE_BURN.get(), this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        ItemEntity itementity = this.m_19998_((ItemLike)ModItems.ANCIENT_HELMET.get());
        if (itementity != null) {
            itementity.m_32064_();
        }
    }

    protected SoundEvent m_7515_() {
        return ModSounds.ANCIENT_BLAZE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return ModSounds.ANCIENT_BLAZE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.ANCIENT_BLAZE_DEATH.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getInvulnerableTime() > 0 && source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (source.m_7640_() instanceof LargeFireball && source.m_7639_() instanceof Player) {
            byte shoots = this.getShoots();
            if (shoots < AncientBlazeConfig.largeFireballAmount()) {
                this.setShoots((byte)(shoots + 1));
                return false;
            }
            return true;
        }
        if (source.m_269014_()) {
            return this.f_19796_.m_188503_(4) != 0 && super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        boolean peaceful = this.m_9236_().m_46791_() == Difficulty.PEACEFUL;
        boolean ambientMode = GeneralConfig.get().ambientMode.get();
        if (peaceful || ambientMode || !AncientBlazeConfig.canAttack()) {
            return;
        }
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20227_(0.5) - this.m_20227_(0.5);
        double d3 = target.m_20189_() - this.m_20189_();
        byte shoots = this.getShoots();
        double chance = (double)AncientBlazeConfig.largeFireballChance() / 100.0;
        if (this.f_19796_.m_188500_() < chance && shoots > 0) {
            this.setShoots((byte)(shoots - 1));
            LargeFireball fireballentity = new LargeFireball(this.m_9236_(), (LivingEntity)this, d1, d2, d3, 1);
            fireballentity.m_6034_(fireballentity.m_20185_(), this.m_20227_(0.5) + 0.5, fireballentity.m_20189_());
            this.m_9236_().m_7967_((Entity)fireballentity);
        } else {
            SmallFireball smallfireballentity = new SmallFireball(this.m_9236_(), (LivingEntity)this, d1, d2, d3);
            smallfireballentity.m_6034_(smallfireballentity.m_20185_(), this.m_20227_(0.5) + 0.5, smallfireballentity.m_20189_());
            this.m_9236_().m_7967_((Entity)smallfireballentity);
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.ANCIENT_BLAZE_SHOOT.get(), SoundSource.HOSTILE, 2.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        int amount = AncientBlazeConfig.blazeSpawnCount();
        if (!this.m_9236_().m_5776_() && amount >= 1 && this.m_21224_()) {
            for (int i = 0; i < amount; ++i) {
                Blaze blaze = new Blaze(EntityType.f_20551_, this.m_9236_());
                if (this.m_21532_()) {
                    blaze.m_21530_();
                }
                blaze.m_6593_(this.m_7770_());
                blaze.m_21557_(this.m_21525_());
                blaze.m_20331_(this.m_20147_());
                blaze.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)blaze);
            }
        }
        super.m_142687_(reason);
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected boolean m_8028_() {
        return AncientBlazeConfig.peacefulDespawn() && super.m_8028_();
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_142535_(float p_149683_, float p_149684_, DamageSource p_149685_) {
        return false;
    }

    public boolean m_6147_() {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public int getInvulnerableTime() {
        return (Integer)this.f_19804_.m_135370_(INVULNERABLE_TIME);
    }

    public void setInvulnerableTime(int time) {
        this.f_19804_.m_135381_(INVULNERABLE_TIME, (Object)time);
    }

    public byte getShoots() {
        return (Byte)this.f_19804_.m_135370_(SHOOTS);
    }

    public void setShoots(byte shoots) {
        this.f_19804_.m_135381_(SHOOTS, (Object)shoots);
    }

    public boolean m_7090_() {
        return (Integer)this.f_19804_.m_135370_(INVULNERABLE_TIME) > 0;
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.ANCIENT_BLAZE;
    }
}

